<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>

<!-- Modern Education Section -->
<div class="education-section" style="
    min-height: 100vh; 
    background: linear-gradient(135deg, #F0F8FF 0%, #E6F3FF 50%, #DBEAFE 100%);
    padding: 100px 0 50px 0;
">
    <div class="container">
        <!-- Page Header -->
        <div class="page-header text-center mb-5">
            <h1 class="page-title" style="
                color: #1E3A8A; 
                font-size: 3rem; 
                font-weight: 700; 
                margin-bottom: 1rem;
                background: linear-gradient(135deg, #1E3A8A 0%, #4169E1 50%, #87CEEB 100%);
                -webkit-background-clip: text;
                -webkit-text-fill-color: transparent;
                background-clip: text;
            ">
                <i class="bi bi-mortarboard me-3" style="color: #4169E1;"></i>
                Education History
            </h1>
            <p style="color: #1E3A8A; font-size: 1.2rem;">My academic journey and educational achievements</p>
        </div>

        <!-- Education Timeline -->
        <?php if (empty($education)): ?>
            <div class="empty-state text-center" style="
                background: rgba(255, 255, 255, 0.9); 
                border: 1px solid rgba(135, 206, 235, 0.3); 
                border-radius: 20px; 
                padding: 4rem 2rem;
                box-shadow: 0 8px 25px rgba(65, 105, 225, 0.1);
            ">
                <i class="bi bi-mortarboard-fill" style="font-size: 4rem; color: #4169E1; margin-bottom: 1rem;"></i>
                <h3 style="color: #1E3A8A; margin-bottom: 1rem;">No Education Records Found</h3>
                <p style="color: #1E3A8A; opacity: 0.8;">Educational history will be displayed here when available.</p>
            </div>
        <?php else: ?>
            <div class="education-timeline-modern">
                <?php foreach ($education as $index => $edu): ?>
                    <div class="education-card" style="
                        background: rgba(255, 255, 255, 0.95); 
                        border: 1px solid rgba(135, 206, 235, 0.3); 
                        border-radius: 20px; 
                        padding: 2rem;
                        margin-bottom: 2rem;
                        box-shadow: 0 8px 25px rgba(65, 105, 225, 0.1);
                        position: relative;
                        transition: all 0.3s ease;
                    " onmouseover="this.style.transform='translateY(-5px)'; this.style.boxShadow='0 15px 35px rgba(65, 105, 225, 0.2)'" 
                       onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='0 8px 25px rgba(65, 105, 225, 0.1)'">
                        
                        <!-- Timeline Connector -->
                        <?php if ($index < count($education) - 1): ?>
                            <div class="timeline-connector" style="
                                position: absolute;
                                left: 30px;
                                bottom: -2rem;
                                width: 2px;
                                height: 2rem;
                                background: linear-gradient(180deg, #4169E1, #87CEEB);
                                z-index: 1;
                            "></div>
                        <?php endif; ?>
                        
                        <!-- Timeline Dot -->
                        <div class="timeline-dot" style="
                            position: absolute;
                            left: 20px;
                            top: 2rem;
                            width: 20px;
                            height: 20px;
                            border-radius: 50%;
                            background: linear-gradient(135deg, #87CEEB, #4169E1);
                            border: 4px solid #FFFFFF;
                            box-shadow: 0 0 0 2px rgba(65, 105, 225, 0.3);
                            z-index: 2;
                        "></div>
                        
                        <!-- Content -->
                        <div style="margin-left: 60px;">
                            <div class="row align-items-start">
                                <div class="col-lg-8">
                                    <!-- School Name -->
                                    <h3 style="color: #1E3A8A; font-weight: 700; margin-bottom: 1rem;">
                                        <i class="bi bi-building me-2" style="color: #4169E1;"></i>
                                        <?= esc($edu['nama_sekolah']) ?>
                                    </h3>
                                    
                                    <!-- Badges -->
                                    <div class="education-badges mb-3">
                                        <span class="badge-modern badge-primary">
                                            <i class="bi bi-mortarboard-fill me-1"></i>
                                            <?= esc($edu['jenjang']) ?>
                                        </span>
                                        <?php if ($edu['jurusan']): ?>
                                            <span class="badge-modern badge-secondary">
                                                <i class="bi bi-book me-1"></i>
                                                <?= esc($edu['jurusan']) ?>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                    
                                    <!-- Description -->
                                    <?php if ($edu['deskripsi']): ?>
                                        <p style="color: #1E3A8A; line-height: 1.6; margin-bottom: 1rem;">
                                            <?= esc($edu['deskripsi']) ?>
                                        </p>
                                    <?php endif; ?>
                                </div>
                                
                                <div class="col-lg-4 text-lg-end">
                                    <!-- Status Badge -->
                                    <?php 
                                    $status = $edu['status_pendidikan'] ?? 'lulus';
                                    if (empty($edu['tahun_selesai']) && $status !== 'sedang_menempuh') {
                                        $status = 'sedang_menempuh';
                                    }
                                    ?>
                                    
                                    <div class="status-section mb-3">
                                        <?php if ($status === 'sedang_menempuh'): ?>
                                            <span class="status-badge status-ongoing">
                                                <i class="bi bi-clock me-1"></i>Currently Studying
                                            </span>
                                        <?php elseif ($status === 'lulus'): ?>
                                            <span class="status-badge status-completed">
                                                <i class="bi bi-check-circle me-1"></i>Graduated
                                            </span>
                                        <?php elseif ($status === 'tidak_lulus'): ?>
                                            <span class="status-badge status-incomplete">
                                                <i class="bi bi-x-circle me-1"></i>Not Completed
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                    
                                    <!-- Period -->
                                    <div class="period-section mb-3">
                                        <?php if ($edu['tahun_mulai'] && $edu['tahun_selesai']): ?>
                                            <div class="period-item">
                                                <i class="bi bi-calendar-range me-2" style="color: #4169E1;"></i>
                                                <span style="color: #1E3A8A; font-weight: 600;">
                                                    <?= esc($edu['tahun_mulai']) ?> - <?= esc($edu['tahun_selesai']) ?>
                                                </span>
                                            </div>
                                        <?php elseif ($edu['tahun_mulai']): ?>
                                            <div class="period-item">
                                                <i class="bi bi-calendar me-2" style="color: #87CEEB;"></i>
                                                <span style="color: #1E3A8A; font-weight: 600;">
                                                    Started: <?= esc($edu['tahun_mulai']) ?>
                                                    <?= $status === 'sedang_menempuh' ? ' (Ongoing)' : '' ?>
                                                </span>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    
                                    <!-- Grade -->
                                    <?php if ($edu['nilai_akhir']): ?>
                                        <div class="grade-section">
                                            <div class="grade-item" style="
                                                background: rgba(240, 248, 255, 0.8); 
                                                border-radius: 12px; 
                                                padding: 12px 16px;
                                                border-left: 4px solid #FFD700;
                                            ">
                                                <i class="bi bi-trophy-fill me-2" style="color: #FFD700;"></i>
                                                <span style="color: #1E3A8A; font-weight: 600;">
                                                    Final Grade: <?= esc($edu['nilai_akhir']) ?>
                                                </span>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>

            <!-- Modern Pagination -->
            <?php if (isset($lastPage) && $lastPage > 1): ?>
                <nav aria-label="Page navigation" class="mt-5">
                    <div class="pagination-modern d-flex justify-content-center align-items-center gap-2">
                        <?php if ($currentPage > 1): ?>
                            <a class="pagination-btn pagination-prev" href="<?= base_url('education?page=' . ($currentPage - 1) . '&search=' . urlencode($search ?? '') . '&jenjang=' . urlencode($filter['jenjang'] ?? '') . '&tahun_mulai=' . urlencode($filter['tahun_mulai'] ?? '') . '&tahun_selesai=' . urlencode($filter['tahun_selesai'] ?? '') . '&sort=' . ($sort ?? 'tahun_mulai') . '&order=' . ($order ?? 'DESC')) ?>">
                                <i class="bi bi-chevron-left"></i>
                            </a>
                        <?php endif; ?>
                        
                        <?php for ($i = 1; $i <= $lastPage; $i++): ?>
                            <a class="pagination-btn <?= $i == $currentPage ? 'active' : '' ?>" 
                               href="<?= base_url('education?page=' . $i . '&search=' . urlencode($search ?? '') . '&jenjang=' . urlencode($filter['jenjang'] ?? '') . '&tahun_mulai=' . urlencode($filter['tahun_mulai'] ?? '') . '&tahun_selesai=' . urlencode($filter['tahun_selesai'] ?? '') . '&sort=' . ($sort ?? 'tahun_mulai') . '&order=' . ($order ?? 'DESC')) ?>">
                                <?= $i ?>
                            </a>
                        <?php endfor; ?>
                        
                        <?php if ($currentPage < $lastPage): ?>
                            <a class="pagination-btn pagination-next" href="<?= base_url('education?page=' . ($currentPage + 1) . '&search=' . urlencode($search ?? '') . '&jenjang=' . urlencode($filter['jenjang'] ?? '') . '&tahun_mulai=' . urlencode($filter['tahun_mulai'] ?? '') . '&tahun_selesai=' . urlencode($filter['tahun_selesai'] ?? '') . '&sort=' . ($sort ?? 'tahun_mulai') . '&order=' . ($order ?? 'DESC')) ?>">
                                <i class="bi bi-chevron-right"></i>
                            </a>
                        <?php endif; ?>
                    </div>
                    
                    <div class="pagination-info text-center mt-3">
                        <span style="color: #1E3A8A; font-size: 0.9rem;">
                            Page <?= $currentPage ?> of <?= $lastPage ?>
                        </span>
                    </div>
                </nav>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>

<!-- Custom Styles -->
<style>
.badge-modern {
    padding: 8px 16px;
    border-radius: 20px;
    font-size: 0.85rem;
    font-weight: 600;
    margin-right: 8px;
    margin-bottom: 8px;
    display: inline-flex;
    align-items: center;
}

.badge-primary {
    background: linear-gradient(135deg, #87CEEB, #4169E1);
    color: white;
}

.badge-secondary {
    background: rgba(135, 206, 235, 0.2);
    color: #4169E1;
    border: 1px solid rgba(135, 206, 235, 0.3);
}

.status-badge {
    padding: 8px 16px;
    border-radius: 20px;
    font-size: 0.9rem;
    font-weight: 600;
    display: inline-flex;
    align-items: center;
}

.status-ongoing {
    background: rgba(255, 193, 7, 0.2);
    color: #B8860B;
    border: 1px solid rgba(255, 193, 7, 0.3);
}

.status-completed {
    background: rgba(40, 167, 69, 0.2);
    color: #155724;
    border: 1px solid rgba(40, 167, 69, 0.3);
}

.status-incomplete {
    background: rgba(220, 53, 69, 0.2);
    color: #721c24;
    border: 1px solid rgba(220, 53, 69, 0.3);
}

.period-item, .grade-item {
    display: flex;
    align-items: center;
    margin-bottom: 8px;
}

.pagination-modern {
    flex-wrap: wrap;
}

.pagination-btn {
    width: 45px;
    height: 45px;
    border-radius: 12px;
    background: rgba(255, 255, 255, 0.9);
    border: 1px solid rgba(135, 206, 235, 0.3);
    color: #1E3A8A;
    text-decoration: none;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 600;
    transition: all 0.3s ease;
}

.pagination-btn:hover {
    background: rgba(65, 105, 225, 0.1);
    border-color: #4169E1;
    color: #4169E1;
    transform: translateY(-2px);
}

.pagination-btn.active {
    background: linear-gradient(135deg, #87CEEB, #4169E1);
    border-color: transparent;
    color: white;
    box-shadow: 0 4px 15px rgba(65, 105, 225, 0.3);
}

/* Mobile Responsive */
@media (max-width: 768px) {
    .page-title {
        font-size: 2.5rem !important;
    }
    
    .education-card {
        padding: 1.5rem !important;
        margin-left: 0 !important;
    }
    
    .timeline-dot {
        display: none;
    }
    
    .timeline-connector {
        display: none;
    }
    
    .education-card > div {
        margin-left: 0 !important;
    }
    
    .col-lg-4 {
        margin-top: 1rem;
        text-align: left !important;
    }
}

@media (max-width: 576px) {
    .badge-modern {
        font-size: 0.8rem;
        padding: 6px 12px;
    }
    
    .status-badge {
        font-size: 0.85rem;
        padding: 6px 12px;
    }
    
    .pagination-btn {
        width: 40px;
        height: 40px;
    }
}
</style>

<?= $this->endSection() ?>

